scriptName _SpeedMCM extends SKI_ConfigBase  

; -- P R O P E R T I E S --------------------------------------------------------------------------

GlobalVariable Property _SpeedRate  Auto
GlobalVariable Property _SpeedMax  Auto
GlobalVariable Property _SpeedMin  Auto

_SpeedQuestScript Property _SpeedQuest  Auto


; -- E V E N T S ----------------------------------------------------------------------------------

event OnConfigInit()
endEvent


event OnConfigClose()
	; Apply any changes
	_SpeedQuest.UpdateSpeed()	

endEvent


event OnPageReset( string Page )

	; Define page layout
	SetCursorFillMode( TOP_TO_BOTTOM )
	
	; Left column
	AddHeaderOption( "Speed Adjustments" )
	AddSliderOptionST( "SLD_MIN", "Minimum speed", _SpeedMin.GetValue() )
	AddSliderOptionST( "SLD_MAX", "Maximum speed", _SpeedMax.GetValue() )
	AddSliderOptionST( "SLD_RATE", "Speed increase per level", _SpeedRate.GetValue(), "{1}" )
	
	; Right column
	SetCursorPosition( 1 )
	AddHeaderOption( "Adjustment Results" )
	AddTextOptionST( "TXT_CURRENT", "Current speed", Game.GetPlayer().GetAV( "SpeedMult" ) )
	AddTextOptionST( "TXT_ADJUSTED", "New adjusted speed", _SpeedQuest.GetAdjustedSpeed() )
	AddTextOptionST( "TXT_LEVEL", "Max speed level", GetMaxLevel() )

endEvent

; -- F U N C T I O N S ----------------------------------------------------------------------------

int function GetMaxLevel()

	return ( ( ( _SpeedMax.GetValue() - _SpeedMin.GetValue() ) / _SpeedRate.GetValue() ) + 1 ) as int

endFunction


; -- S T A T E - B A S E D   F U N C T I O N S ----------------------------------------------------

state SLD_MIN

	event OnHighlightST()
		SetInfoText( "Set the minimum value of SpeedMult.  This is the value you will be at level 1.  Default = 100." )
		
	endEvent
	
	event OnSliderOpenST()
		SetSliderDialogStartValue( _SpeedMin.GetValue() )
		SetSliderDialogDefaultValue( 100.0 )
		SetSliderDialogRange( 0.0, 300.0 )
		SetSliderDialogInterval( 1.0 )
		
	endEvent
	
	event OnSliderAcceptST( float newValue )
		_SpeedMin.SetValue( newValue )
		
		if newValue > _SpeedMax.GetValue()
			_SpeedMax.SetValue( newValue )
			
		endIf

		ForcePageReset()
		
	endEvent

endState


state SLD_MAX

	event OnHighlightST()
		SetInfoText( "Set the maximum value of SpeedMult.  Default = 150 which seems to be about how fast city guards walk." )
		
	endEvent
	
	event OnSliderOpenST()
		SetSliderDialogStartValue( _SpeedMax.GetValue() )
		SetSliderDialogDefaultValue( 150.0 )
		SetSliderDialogRange( 0.0, 300.0 )
		SetSliderDialogInterval( 1.0 )
		
	endEvent
	
	event OnSliderAcceptST( float newValue )
		_SpeedMax.SetValue( newValue )
		
		if newValue < _SpeedMin.GetValue()
			_SpeedMin.SetValue( newValue )
			
		endIf
		
		ForcePageReset()
		
	endEvent

endState


state SLD_RATE

	event OnHighlightST()
		SetInfoText( "Set how much to increase the value of SpeedMult each time you level up.  Default = 0.5" )
		
	endEvent
	
	event OnSliderOpenST()
		SetSliderDialogStartValue( _SpeedRate.GetValue() )
		SetSliderDialogDefaultValue( 0.5 )
		SetSliderDialogRange( 0.0, 2.0 )
		SetSliderDialogInterval( 0.1 )
		
	endEvent
	
	event OnSliderAcceptST( float newValue )
		_SpeedRate.SetValue( newValue )
		ForcePageReset()
		
	endEvent

endState


state TXT_CURRENT

	event OnHighlightST()
		SetInfoText( "This is the current value of SpeedMult." )
		
	endEvent
	
endState


state TXT_ADJUSTED

	event OnHighlightST()
		SetInfoText( "This is what the value of SpeedMult will be based on your current settings." )
		
	endEvent
	
endState


state TXT_LEVEL

	event OnHighlightST()
		SetInfoText( "This is the level you need to be to reach the maximum value of SpeedMult base on your current settings." )
		
	endEvent
	
endState


; -------------------------------------------------------------------------------------------------